/*******************************************************}
{                                                       }
{               Borland DB Web                          }
{           Data aware Web controls                     }
{ Copyright (c) 2003, 2005 Borland Software Corporation }
{                                                       }
{*******************************************************/

using System;
using System.Data;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.ComponentModel.Design.Serialization;
using System.Drawing;
using System.Drawing.Design;
using System.Text;


namespace Borland.Data.Web
{

	#region DBWebSound

	/// <summary>
	/// Data aware Image control for use with DBWebDataSource
	/// </summary>

	[DefaultProperty("Text"),
	Designer("Borland.Data.Web.DBWebControlDesigner"),
	ToolboxBitmap(typeof(Borland.Data.Web.DBWebSound),
	"Borland.Data.Web.DBWebSound.bmp"),
	ToolboxData("<{0}:DBWebSound runat=server></{0}:DBWebSound>")]
	public class DBWebSound : WebControl, IDBWebColumnLink, IPostBackDataHandler
	{
		const string TempFile = "_BrlndSnd";
		const string mp3Ext      = ".mp3";
		const string wavExt      = ".wav";
		protected const int MinWidth = 50;
		protected const int MinHeight = 20;
		private string SoundUrl;
		private string physicalSoundFile;
		private bool FUseCacheFile;
		private DBWebColumnLink ColumnLink;
		private IDBWebColumnLink IColumnLink;
		private bool bTempFileNameSet;
		private string FExtension;
		private System.Web.UI.WebControls.Panel FPanel;
		private bool FLoop;
		private bool FAutoStart;

   	public DBWebSound(): base()
      {
         FUseCacheFile = false;
         ColumnLink = new DBWebColumnLink(this);
         IColumnLink = (ColumnLink as IDBWebColumnLink);
			bTempFileNameSet = false;
			FExtension = mp3Ext;
			FPanel = new System.Web.UI.WebControls.Panel();
			FPanel.Width = MinWidth*3;
			this.Width = FPanel.Width;
			this.Height = FPanel.Height;
		}

		protected override void OnInit(EventArgs e)
		{
			base.OnInit(e);
			if( Page != null )
				Page.RegisterRequiresPostBack(this);
      }

      public override void Dispose()
      {
         if( ClassUtils.IsDesignTime(Page) )
	      	DeleteTempFile();
         base.Dispose();
      }


      #region Layout
		[LocalizableCategoryAttribute("Layout")]
      public override Unit Width
      {
      	get
         {
         	return base.Width;
         }
         set
         {
         	if( value.Value >= MinWidth )
            {
	         	base.Width = value;
   	         FPanel.Width = value;
            }
         }
      }


		[LocalizableCategoryAttribute("Layout")]
      public override Unit Height
      {
      	get
         {
         	return base.Height;
         }
         set
         {
         	if( value.Value >= MinHeight )
            {
	         	base.Height = value;
   	         FPanel.Height = value;
            }
         }
		}
		#endregion

		[LocalizableCategoryAttribute("Sound"),
		DefaultValue(false)]
		[LocalizableDescriptionAttribute("Loop")]
		public bool Loop
		{
			get
			{
				return FLoop;
			}
			set
			{
				FLoop = value;
			}
		}
		[LocalizableCategoryAttribute("Sound"),
		DefaultValue(false)]
		[LocalizableDescriptionAttribute("AutoStart")]
		public bool AutoStart
		{
			get
			{
				return FAutoStart;
			}
			set
			{
				FAutoStart = value;
			}
		}
		// figure out what the physical image file name should be,
		// and also what the url should be for that filename.
      protected void SetUrlAndFileName(int ImageIndex)
		{
         // get Unique temp file Name for designtime image
			string sPath;
			string fileName;
			if( ClassUtils.IsDesignTime(Page) )
			{
         	sPath = Directory.GetCurrentDirectory() + "\\";
         	fileName = TempFile + this.ID;
         }
         else  // at runtime, use Session.SessionID
         {
            Object oParentRow = Page.Session[ClassUtils.GetPageName(Page) + TableName + DBWebConst.sParentRow];
            string sParentRow = "_";
            if( oParentRow != null )
            {
            	int iParentRow = Convert.ToInt32(oParentRow);
               if( iParentRow >= 0 )
            		sParentRow = Convert.ToString(iParentRow) + "_";
            }
            sPath = Page.Request.PhysicalApplicationPath;
         	fileName = TempFile + this.ID + Convert.ToString(Page.Session.SessionID) +
            				sParentRow + Convert.ToString(ImageIndex);;
            object lastFile = Page.Session[this.ID + DBWebConst.sBorlandImageFile];
            if( lastFile != null )
            	DeleteFile(Convert.ToString(lastFile) );
         }
         int iFileIndex = 1;
         physicalSoundFile = fileName;
      	while( File.Exists(sPath + physicalSoundFile) )
			{
         	{  // if DeleteFile fails, increment the FileIndex
            	if(! DeleteFile(sPath + physicalSoundFile) )
               {
		         	physicalSoundFile = fileName + Convert.ToString(iFileIndex);
   		         iFileIndex++;
               }
            }
         }
         if( ClassUtils.IsDesignTime(Page) )
			{
				if( sPath.IndexOf(':') == 1  )
					SoundUrl = "file:///" + sPath.Substring(3) + physicalSoundFile;
				else
					SoundUrl = "file:///" + sPath + physicalSoundFile;
            physicalSoundFile = sPath + physicalSoundFile;
         }
         else
         {
         	SoundUrl = "http://" + Page.Request.Url.Host + Page.Request.ApplicationPath + "/" + physicalSoundFile;
            physicalSoundFile = sPath + physicalSoundFile;
            Page.Session[this.ID + DBWebConst.sBorlandImageFile] = physicalSoundFile;
         }
         bTempFileNameSet = true;
      }

      #region IDBWebDataLink
      string IDBWebDataLink.TableName
      {
      	get
         {
         	return IColumnLink.TableName;
         }
         set
         {
         	IColumnLink.TableName = value;
         }
      }
      IDBDataSource IDBWebDataLink.DBDataSource
      {
      	get
         {
         	return IColumnLink.DBDataSource;
         }
         set
         {
         	IColumnLink.DBDataSource = value;
         }
      }
      #endregion
      #region IDBWebColumnLink
      string IDBWebColumnLink.ColumnName
      {
      	get
         {
         	return IColumnLink.ColumnName;
         }
         set
         {
            if( !ClassUtils.SameValue(IColumnLink.ColumnName, value ) )
               DeleteTempFile();
         	IColumnLink.ColumnName = value;
         }
      }
      #endregion

      [Editor(typeof(Borland.Data.Web.TableNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(null)]
		[LocalizableDescriptionAttribute("TableName")]
      public string TableName
      {
      	get
         {
	      	return IColumnLink.TableName;
         }
      	set
         {
            if( !ClassUtils.SameValue(IColumnLink.TableName, value ) )
               DeleteTempFile();
	      	IColumnLink.TableName = value;
         }
      }
		[LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
		DefaultValue(null)]
		[LocalizableDescriptionAttribute("DataSource")]
      public IDBDataSource DBDataSource
      {
      	get
         {
         	return IColumnLink.DBDataSource;
         }
         set
         {
         	IColumnLink.DBDataSource = value;
         }
      }


		[LocalizableCategoryAttribute(DBTypes.sDBWebControl),
      Editor(typeof(Borland.Data.Web.ImageColumnPropEditor), typeof(UITypeEditor)),
		DefaultValue(null)]
		[LocalizableDescriptionAttribute("ColumnName")]
      public string ColumnName
      {
      	get
         {
         	return IColumnLink.ColumnName;
         }
         set
         {
         	IColumnLink.ColumnName = value;
         }
      }
		[LocalizableCategoryAttribute(DBTypes.sDBWebControl),
      DefaultValue(false)]
		[LocalizableDescriptionAttribute("UseCacheFile")]
      public bool UseCacheFile
      {
      	get
         {
         	return FUseCacheFile;
         }
         set
         {
         	FUseCacheFile = value;
         }
      }

      #region IPostBackDataHandler
      // RaisePostDataChangedEvent is called prior to DataBind()
      // DataSet and related properties are NOT available here
      // Child controls are not available
		bool IPostBackDataHandler.LoadPostData(string postDataKey,
			NameValueCollection postCollection)
      {
         if( this.Visible )
	      	ColumnLink.LoadPostData(postDataKey, postCollection);
         return false;
      }

	   void IPostBackDataHandler.RaisePostDataChangedEvent()
   	{
	   }
      #endregion

		protected override void OnPreRender(EventArgs args)
		{
			base.OnPreRender(args);
			bool IsPostBack = !ClassUtils.IsDesignTime(Page) && Page.IsPostBack;
         if( !IsPostBack )
         	DeleteTempFiles();
			string s = Page.Request.QueryString[DBWebConst.sBorlandImageID];
         if( s != null && s == this.ID )
         {
				Object o = Page.Session["Snd_" + this.ID];
				Page.Response.BinaryWrite((byte[])o);
            Page.Response.End();
         }
         else
         {
            DataBind();
         }
		}

      // design-time or FUseCacheFile is true;
      protected void CreateImageFile(byte[] byteBlobData)
      {
         bool bFileInUse = false;
      	if( ClassUtils.IsDesignTime(Page) || FUseCacheFile )
         {
	         if( File.Exists(physicalSoundFile) )
   	      {
      	   	try
         	   {
            		File.Delete(physicalSoundFile);
	            }
   	         catch
      	      {
         	   	// ignore error if file is in use by the IDE
            	   bFileInUse = true;
					}
				}
         }
         if( !bFileInUse )
         {
         	FileStream s = File.Create(physicalSoundFile);
            try
            {
					int bytes = byteBlobData.Length;
               s.Write(byteBlobData, 0, bytes);
            }
            finally
            {
            	s.Close();
            }
         }
      }


		protected byte[] GetSound( DataRow row )
		{
			if( row != null )
			{
				if( ! row.IsNull(IColumnLink.ColumnName) )
				{
					Byte[] byteBlobData = new Byte[0];
					try
					{
						byteBlobData = (Byte[])row[IColumnLink.ColumnName];
						return byteBlobData;
					}
					catch
					{
						return null;
					}
				}
			}
			return null;
      }

		protected override void Render(HtmlTextWriter output)
		{
			bool error = ClassUtils.OutputErrors(Page, output, IColumnLink);
			if( !error || (IColumnLink.DBDataSource as DBWebDataSource).ErrorOption != ErrorHtmlOption.logOnErrorPage )
			{
				output.Write(Text);
			}
			else  // if going to a separate error hmtl page, output "OK" button.
			{
				ClassUtils.OutputOKButton(output);
				Page.Response.End();
			}
		}

		public override void DataBind()
		{
			try
			{
				if( !ClassUtils.IsDesignTime(Page) )
					Page.Session.Remove("Snd_" + this.ID);
				base.DataBind();
				if( ColumnLink.IsDataBound )
				{
					Type type;
					Object thisObject = IColumnLink.DBDataSource.GetColumnValue(Page,
										IColumnLink.TableName, IColumnLink.ColumnName, out type);
					if( thisObject == null )
						SoundUrl = "";
					else if( type == Type.GetType(TypeLiterals.SystemString) )
					{
						SoundUrl = Convert.ToString(thisObject);
					}
					else
					{
						Byte[] byteBlobData = null;
						try
						{
							byteBlobData = ((Byte[]) thisObject);
						}
						catch( Exception ex )
						{  // GetType() has failed to calculate String FieldType
							byteBlobData = null;
						}
						if( byteBlobData != null )
						{
							if( ClassUtils.IsDesignTime(Page) || FUseCacheFile )
							{
								int ImageIndex = 0;
								if( !ClassUtils.IsDesignTime(Page) )
								{
									object o = Page.Session[ClassUtils.GetPageName(Page) + TableName + DBWebConst.sImageIndex];
									if( o != null )
										ImageIndex = Convert.ToInt32(o) + 1;
									Page.Session[ClassUtils.GetPageName(Page) + TableName + DBWebConst.sImageIndex] = ImageIndex;
								}
								SetUrlAndFileName(ImageIndex);
								CreateImageFile(byteBlobData);
							}
							else
							{
								Page.Session["Snd_" + this.ID] = byteBlobData;
								SoundUrl = "http://" + Page.Request.Url.Host +
										Page.Request.Url.AbsolutePath + "?" + DBWebConst.sBorlandImageID + "=" + this.ID;  // { do not localize}
							}
						}
					}
					base.DataBind();
				}
				ChildControlsCreated = true;
				if( this.Width.Value > MinWidth )
					ClassUtils.SetSizeProperties( FPanel, this );
				ClassUtils.SetOuterAppearanceProperties( FPanel, this );
			}
			catch(Exception ex)
			{
				if( !ClassUtils.IsDesignTime(Page) )
				{
					Page.Response.Write(ClassUtils.GetInternalError(Page, IColumnLink, ex, this.ID));
				}
				else
					throw new Exception(ex.Message);
			}
		}


		private bool DeleteFile(string fileName)

      {

      	try

         {

         	if( File.Exists(fileName) )

            	File.Delete(fileName);

            return true;

         }

         catch

         {

         	// ignore file in use exceptions

         }

         return false;

      }


		private void DeleteTempFile()

		{

      	if( ClassUtils.IsDesignTime(Page) )

         	DeleteFile(physicalSoundFile);

      }


      private void DeleteTempFiles()

      {

      	DirectoryInfo de = new DirectoryInfo(Page.Request.PhysicalApplicationPath);

         FileInfo[] files = de.GetFiles(TempFile + this.ID + "*");

         foreach( FileInfo file in files )

	      	DeleteFile(file.FullName);

   	}


		protected string Text

		{
			get
			{
				string autostart;
				string loop;
				if( FLoop )
					loop = " loop=\"true\"";
				else
					loop = " loop=\"false\"";
				if( FAutoStart )
					autostart = " autostart=\"true\"";
				else
					autostart = " autostart=\"false\"";
				StringWriter sw = new StringWriter();
				HtmlTextWriter tw = new HtmlTextWriter(sw);
				DataBind();
				ClassUtils.AddStyleToWebControl(FPanel, this.Style);
				FPanel.RenderBeginTag(tw);
				tw.Write("<embed src=\"" + SoundUrl + "\"" + autostart + loop +"></embed>");
				FPanel.RenderEndTag(tw);
				return sw.ToString();
			}
		}


   }
   #endregion
}

